//Solve the s-wave radial Schrodinger equation for a particle of mass m
//for an harmonic oscillator potential for ground state energy (in MeV).

close;
clear;
clc;

// declaring constant values
hbarc=197.3  //Plancks constant h divided by 2*(pi) called as hbarc=(h/2*pi)*c. 
mcsq=940;  // mass of electron*c^2 = mcsq in units of (MeV);
k = 100;   // harmonic oscillator potential constant in units of MeV fm-2
b = 0;  
disp("The value of b in the potential is chosen to be:");
disp(b)
//To obtain the plot the potential V(r) as a function of 'r' 
r_min = 0;  
r_max = 4; 
N =  input("Input the number of intervals (should be around 500 to 1000 for good computation: )")
s = (r_max-r_min)/N;  //step size 
factor1=-(hbarc^2)/(2*mcsq*s^2);  

// making a row vector to input r values 
for i=1:1:N
    rmat(1,i)=r_min+(i-1)*s
end

for ir = 1:1:size(rmat,2)
    r = rmat(ir);
V(1,ir) = 0.5*k*(r)^2 + 0.5*b*(r)^3;  
end
figure;
plot(rmat,V,'-.','linewidth',3) 

// Kinetic energy matrix (Using central difference formula)
T=zeros(N,N)
for i=1:1:N
    T(i,i)=-2;
    if (i<N)
        T(i,i+1)=1;
        T(i+1,i)=1
    end
end

T_matrix = factor1*T; // Kinetic Energy Matrix final in MeV 

// Potential energy matrix in MeV 
U_matrix = zeros(N,N)
for i = 1:1:N    
U_matrix(i,i)=V(i)
end

// Hamiltonian matrix
Ham = T_matrix+U_matrix;
[u,eigen] = spec(Ham);
eigval_numeric = spec(Ham)


disp ('The first five eigen values obtained using FDM are:')
disp(eigval_numeric(1:5))

//Plotting the eigenvalues obtained by numerical computation

for n =1:1:5
    eigvalue_num = eigval_numeric(n)
    eigvalue_num_vector = eigvalue_num*ones(1,N);
    plot(rmat,eigvalue_num_vector,'r')
end


// normalisation check (The value comes out to be 1)
normalisation = sum((u(:,1).*conj(u(:,1))))

// plotting the eigen functions. 
//(plot of mod psi squared). Done the scaling of eigen function magnitude 

psisq1 = (1/normalisation)*(u(:,1).*conj(u(:,1)))
plot(rmat(1,:),8000*psisq1'+eigval_numeric(1),'k')

psisq2 = (1/normalisation)*(u(:,2).*conj(u(:,2)))
plot(rmat(1,:),8000*psisq2'+eigval_numeric(2),'k')

psisq3 = (1/normalisation)*(u(:,3).*conj(u(:,3)))
plot(rmat(1,:),8000*psisq3'+eigval_numeric(3),'k')

psisq4 = (1/normalisation)*(u(:,4).*conj(u(:,4)))
plot(rmat(1,:),8000*psisq4'+eigval_numeric(4),'k')

psisq5 = (1/normalisation)*(u(:,5).*conj(u(:,5)))
plot(rmat(1,:),8000*psisq5'+eigval_numeric(5),'k')

title('Plot of first 5 probability density functions ','fontsize',2);
xlabel('r (in fm) -->','fontsize',2)
ylabel('Energy(in MeV)and scaled probability density functions)','fontsize',2)

legend(['Potential Plot','Eigenvalues'])
